////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform mat4 uProjection;
uniform mat4 uModelView;

in vec4 aPosition;
in vec3 aNormal;
in vec2 aTexCoord;

out vec3 vPosition;
out vec2 vTexCoord;

void main()
{
    vec4 pos = uModelView * aPosition;
    vPosition = vec3(pos);
    vTexCoord = aTexCoord;

    /*vec4 p = uProjection*uView*uWorld*vec4(aPosition.x, aPosition.y, -1.0f, 1.0f);
    vProj = -p.xy/p.w;*/

    gl_Position = uProjection*pos;
} 
