////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2D uSamplerTexture;
uniform sampler2D uSamplerDiscarding;
uniform vec4 uColor;

uniform vec3 uLightColor;
uniform vec3 uLightDir;

uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uViewMatrix;

uniform float uTime;
uniform float uShipSpeed;

//uniforms for CoC computation
uniform float uAperture;
uniform float uFocalLength;
uniform float uFocus;
uniform vec2 uCameraRange;

uniform float uDecalOnly;
uniform float uBarFadeout;

in vec2 vVelocity;
in vec4 eyePos;
in vec3 vEyeNormal;
in vec2 vTexCoord;
in float vAlpha;

out vec4 fFragDataEyeNormal;
out vec4 fFragDataColor;
out vec4 fFragDataVelocity;

vec3 directionalLight(
    vec3 diffuse,
    float glow,
    vec3 specColor,
    vec3 ambient,
    vec3 eyeLightDir,
    vec3 lightColor,
    vec3 eyeVPos,
    vec3 eyeNormal
    );


void main(void)
{
    vec3 randomSeed = uColor.rgb*2.0f-1.0f;


    vec2 flowDirection1 = (vec2(randomSeed.r*0.3f + randomSeed.g*0.1f + randomSeed.b*0.6f, randomSeed.r*0.1f + randomSeed.g*0.7f + randomSeed.b*0.2f))+vec2(-uShipSpeed*0.0f,0.0f);
    vec2 flowDirection2 = (vec2(randomSeed.r*0.5f + randomSeed.g*0.2f + randomSeed.b*0.3f, randomSeed.r*0.9f + randomSeed.g*0.05f + randomSeed.b*0.05f))+vec2(-uShipSpeed*0.0f,0.f);
    float discardTex1 = texture(uSamplerDiscarding, (vTexCoord + (uTime/4.0) * flowDirection1)*0.05f).r;
    float discardTex2 = texture(uSamplerDiscarding, (vTexCoord + (uTime/4.0) * flowDirection2)*0.05f).r;
    float discardTex = mix(discardTex1, discardTex2, (sin(randomSeed.r*3.0f*randomSeed.g*5.0f)*0.25f+0.5f));

    float fadeout = min(uBarFadeout + discardTex, 1.0);

    if ((fadeout < 0.95f) && (fadeout > 0.8f))
        fadeout *= (fadeout-0.8f) / (0.95f-0.8f);
    else if (fadeout < 0.8)
        fadeout *= 0.0f;

    vec4 texColor = texture(uSamplerTexture, vTexCoord);

    vec3 eyeLightDirection = normalize((uViewMatrix * vec4(uLightDir, 0.0)).xyz);
    vec3 eyeNormal = normalize(vEyeNormal);


    if(gl_FrontFacing)
        eyeNormal = eyeNormal;
    else
        eyeNormal = -eyeNormal;

    float glow = clamp(1.0-texColor.b, 0.0f, 1.0f);

    fFragDataColor.rgb = clamp(uColor.rgb , vec3(0.0), vec3(1.0));
    fFragDataColor.a = clamp((texColor.r * glow * fadeout ), 0, 1);

    float bias = 0.0;
    float scale = 1.0;
    float power = 1.0f;
    float fresnel = bias + scale * pow(1 -  abs(dot(vec3(0,0,1), eyeNormal)), power);
    fresnel = clamp(fresnel, 0, 1);
    fFragDataColor.rgba *= clamp(mix(0.7, 1.6, fresnel) * vAlpha, 0, 1);

    //fFragDataColor.rgba = mix(fFragDataColor.rgba, vec4((eyeNormal * 0.5 + 0.5) * .3 *  (1 - uDecalOnly), 1.0), 0.999);
    fFragDataColor.rgba = mix(fFragDataColor.rgba, vec4(uColor.rgb * (texColor.a - texColor.b) * vAlpha, (texColor.a - texColor.b) * vAlpha), uDecalOnly);

    fFragDataEyeNormal.rgb = eyeNormal * 0.5 + 0.5;
    fFragDataEyeNormal.a = uColor.a;
    
    fFragDataVelocity.xy = vVelocity;
    fFragDataVelocity.z = 0.0;

    //fFragDataVelocity.a = 1.0;
    float objectdistance = -uCameraRange.y * uCameraRange.x / (gl_FragCoord.z * (uCameraRange.y - uCameraRange.x) - uCameraRange.y);
    fFragDataVelocity.a = abs(uAperture * (uFocalLength * (objectdistance - uFocus)) / (objectdistance * (uFocus - uFocalLength)));

    //fFragDataColor.rg = mix(vTexCoord, fFragDataColor.rg, 0.001);
    //fFragDataColor.b = mix(0, fFragDataColor.b, 0.001);

    fFragDataEyeNormal *= 1 - uDecalOnly;
    fFragDataVelocity *= 1 - uDecalOnly;
}
