////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
in vec4 aPosition;

uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat3 uNormalMatrix;
uniform mat4 uModelViewMatrix;

uniform sampler2D uPolyLine;

uniform float uSampleCount;
uniform float uTextureScale;
uniform float uLaneWidth;
uniform float uLaneOffset;

uniform vec2 uStartEndAlpha;

uniform vec3 uSplineRange;
uniform float uNormalOffset;

out vec3 vEyeNormal;
out vec3 vEyeTangent;
out vec3 vEyeBitangent;

out vec2 vTexCoord;
out vec4 eyePos;
out vec2 vVelocity;
out float vAlpha;

void main()
{
    float t = clamp(aPosition.x, uSplineRange.x, uSplineRange.y) / uSampleCount;

    vec2 relSplineRange = uSplineRange.xy / uSampleCount;

    float innerT = (t - relSplineRange.x) / (relSplineRange.y - relSplineRange.x);
    innerT = clamp(innerT, 0.0, 1.0);

    vAlpha = mix(uStartEndAlpha.x, uStartEndAlpha.y, innerT);

    //get the samples from the polyline texture
    vec4 pos    = texture(uPolyLine, vec2(0.5/3.0, t));
    vec4 normal = texture(uPolyLine, vec2(1.5/3.0, t));
    vec4 right  = texture(uPolyLine, vec2(2.5/3.0, t));

    vec3 forward = normalize(-cross(normal.xyz, right.xyz));

    //shift the lane to its position (given relative to the track's spline by uLaneOffset)
    pos += right * (aPosition.y * uLaneWidth + uLaneOffset);
    pos += normal * uNormalOffset;
    vEyeNormal = uNormalMatrix * normal.xyz;
    vEyeTangent = uNormalMatrix * right.xyz;
    vEyeBitangent = uNormalMatrix * forward.xyz;

    vec4 p = uModelViewProjectionMatrix * pos;
    gl_Position = p;
    eyePos = uModelViewMatrix*pos;

    vec4 prevP = uPreviousModelViewProjectionMatrix * pos;
    vVelocity = (p/p.w - prevP/prevP.w).xy;

    vTexCoord = vec2((innerT-uSplineRange.z) * uTextureScale, aPosition.y + 0.5);

}
