////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uViewMatrix;

uniform sampler2D uNormalMap;


in vec2 vVelocity;
in vec4 eyePos;
in vec3 vEyeNormal;
in vec3 vEyeTangent;
in vec3 vEyeBitangent;
in vec2 vTexCoord;

out vec4 fFragDataEyeNormal;

void main(void)
{
    vec3 eyeNormal = normalize(vEyeNormal);

    mat3 normalTransform = mat3(vEyeTangent, vEyeBitangent, eyeNormal);

    eyeNormal = normalize(normalTransform * (texture(uNormalMap, vTexCoord).rgb*2.0-1.0));


    if(gl_FrontFacing)
        eyeNormal = eyeNormal;
    else
        eyeNormal = -eyeNormal;

    fFragDataEyeNormal.rgb = eyeNormal * 0.5 + 0.5;
    fFragDataEyeNormal.a = 1.0;
}
