////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

vec3 directionalLight(
    vec3 diffuse,
    float glow,
    vec3 specColor,
    vec3 ambient,
    vec3 eyeLightDir,
    vec3 lightColor,
    vec3 eyeVPos,
    vec3 eyeNormal
    )
{
        //Diffuse
        float lambertTerm = clamp(dot(eyeLightDir, eyeNormal.xyz), 0.0, 1.0);
        vec3 finalColor = (lightColor*(lambertTerm*0.7+ambient)+glow) * diffuse;

        //Specular
        vec3 normalizedCameraDirection = normalize(-eyeVPos.rgb);
        vec3 reflectionDirection = reflect(-eyeLightDir, eyeNormal.xyz);
        float specular = pow(max(dot(reflectionDirection, normalizedCameraDirection),0.0), 64.0);
        specular *= clamp(10.0 * dot(eyeLightDir, eyeNormal), 0.0, 1.0);
        return finalColor + specColor * specular;
}
