////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

layout(lines) in;
layout(triangle_strip, max_vertices=4) out;

void main()
{
    vec4 pos1 = gl_in[0].gl_Position;//gl_in[0].gl_Position.w;
    vec4 pos2 = gl_in[1].gl_Position;//gl_in[0].gl_Position.w;

    vec2 normal = vec2(pos1.y / pos1.w - pos2.y / pos2.w, pos2.x / pos2.w - pos1.x / pos1.w);
    if ( length(normal) < 0.00001 ) normal = vec2(1,0);
    //normal = vec2(1,0);
    normal = normalize(normal) * 0.2;

    float size = length(normal / gl_in[0].gl_Position.w);

    if ( size > 0.005 )
        normal = normalize(normal) * gl_in[0].gl_Position.w * 0.005;


    gl_Position = pos1 - vec4(normal, 0, 0) /* gl_in[0].gl_Position.w*/;
    EmitVertex();

    gl_Position = pos2 - vec4(normal, 0, 0) /* gl_in[0].gl_Position.w*/;
    EmitVertex();

    gl_Position = pos1 + vec4(normal, 0, 0) /* gl_in[0].gl_Position.w*/;
    EmitVertex();

    gl_Position = pos2 + vec4(normal, 0, 0) /* gl_in[0].gl_Position.w*/;
    EmitVertex();

    EndPrimitive();
} 
