
////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerColor;
uniform vec4 uColorWeight;
uniform float uColorToLum;

out vec4 fFragData0;

void main(void)
{

    vec4 color0 = texture(uSamplerColor, 2 * gl_FragCoord.xy);
    vec4 color1 = texture(uSamplerColor, 2 * gl_FragCoord.xy + vec2(0.0, 1.0));
    vec4 color2 = texture(uSamplerColor, 2 * gl_FragCoord.xy + vec2(1.0, 0.0));
    vec4 color3 = texture(uSamplerColor, 2 * gl_FragCoord.xy + vec2(1.0, 1.0));

    float lum0;
    float lum1;
    float lum2;
    float lum3;

    if(uColorToLum > 0.5) //map colors to luminance using colorweights
    {
        lum0 = dot(uColorWeight,color0);
        lum1 = dot(uColorWeight,color1);
        lum2 = dot(uColorWeight,color2);
        lum3 = dot(uColorWeight,color3);
    }
    else
    {
        lum0 = color0.r;
        lum1 = color1.r;
        lum2 = color2.r;
        lum3 = color3.r;
    }


    fFragData0 = vec4(max(lum0, max(lum1, max(lum2, lum3))));
}
