////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150


/*
layout(std140) uniform bAffine3D
{
    mat4 uProjectionMatrix;
    mat4 uInverseProjectionMatrix;
    mat4 uViewMatrix;
};
*/


uniform mat4 uProjectionMatrix;
uniform mat4 uInverseProjectionMatrix;
uniform mat4 uViewMatrix;
uniform int uColorType;

uniform vec3 uColor;

uniform sampler2D zBuffer;

uniform sampler2D uTexture;

uniform sampler2D uShapeTexture;

in vec2 vTexCoord;
//in float alphaScale;

in float lifetime;

in vec4 screenPos;


float near = 0.1;
float far = 10000.0;
float readDepth( float depth )
{
    return (2.0 * near) / (far + near - depth * (far - near));
}

const vec3 color = vec3(0.384, 0.343, 0.286);

const vec3 fireColor[5] = vec3[]
(
    vec3(0.0, 0.0, 1.0),
    vec3(1.0, 1.0, 1.0),
    vec3(1.0, 0.0, 0.0),
    vec3(1.0, 0.0, 0.0),
    vec3(0.0, 0.0, 0.0)
);

out vec4 oColor;

vec3 bezierFire1(float t, int start)
{
    return fireColor[start] * (1 - t) + fireColor[start + 1] * t;
}
vec3 bezierFire2(float t, int start)
{
    return bezierFire1(t, start) * (1 - t) + bezierFire1(t, start + 1) * t;
}
vec3 bezierFire3(float t, int start)
{
    return bezierFire2(t, start) * (1 - t) + bezierFire2(t, start + 1) * t;
}
vec3 bezierFire4(float t, int start)
{
    float x = t * 5;
    int index = int(x);
    float prog = x - index;
    return bezierFire3(t, start) * (1 - t) + bezierFire3(t, start + 1) * t;
}

vec3 noiseVec3(int seed)
{
    uint tempSeed = uint(seed);
    vec3 result;
    tempSeed = (tempSeed * 1103515245u + 12345u); result.x = float(tempSeed);
    tempSeed = (tempSeed * 1103515245u + 12345u); result.y = float(tempSeed);
    tempSeed = (tempSeed * 1103515245u + 12345u); result.z = float(tempSeed);
    return result / 4294967296.0;
}

void main()
{

    oColor = vec4(0.0);
    vec2 coords = screenPos.xy / screenPos.w * 0.5 + 0.5;
    float depth = texture(zBuffer, coords).r;
    float currentDepth = gl_FragCoord.z;


    if(uColorType == 0)
    {// default
        oColor.rgb = bezierFire4(lifetime, 0);
    }
    else if(uColorType == 1)
    {// fixed color
        oColor.rgb = uColor.rgb;
    }
    else if(uColorType == 2)
    {// use texture
        oColor.rgb = texture(uTexture, vTexCoord.yx).rgb;
    }


    oColor.a = oColor.r;

    oColor *= texture(uShapeTexture, vTexCoord);


    vec4 currPixel = vec4(screenPos.xy / screenPos.w, gl_FragCoord.z, 1.0);
    vec4 lastPixel = vec4(currPixel.xy, depth, 1.0);

    currPixel = uInverseProjectionMatrix * currPixel;
    lastPixel = uInverseProjectionMatrix * lastPixel;

    currPixel /= currPixel.w;
    lastPixel /= lastPixel.w;

    float distance = length(currPixel - lastPixel);



    if ( distance < 0.5 )
        oColor *= distance / 0.5;

    //oColor *= (1-lifetime);
}
