#version 150

//vertex input
layout(points) in;

//geometry output
layout(triangle_strip, max_vertices = 4) out;


/*
layout(std140) uniform bAffine3D
{
    mat4 uProjectionMatrix;
    mat4 uInverseProjectionMatrix;
    mat4 uViewMatrix;
};
*/

uniform mat4 uProjectionMatrix;
uniform mat4 uInverseProjectionMatrix;
uniform mat4 uViewMatrix;


in float size[1];

flat in int vID[1];

in vec4 vPosition[1];
in vec4 vVelocity[1];
in float vLifetime[1];

out vec2 vTexCoord;
out float lifetime;

out vec4 screenPos;


void main() 
{ 
        vec4 pos_cameraspace = gl_in[0].gl_Position;
	


        vec4 aR = vec4(1.0, uProjectionMatrix[1][1] / uProjectionMatrix[0][0], 0.0, 0.0);

        float height = 1.0 / uProjectionMatrix[0][0];

        vec4 velocity = vVelocity[0];
        lifetime = 1.0 - velocity.a / vLifetime[0];
        velocity.a = 0.0;



        vec4 positionToBe = uProjectionMatrix * uViewMatrix * (vPosition[0] + normalize(velocity));

        vTexCoord = normalize(positionToBe.xy/positionToBe.w - pos_cameraspace.xy/pos_cameraspace.w);

        float angle = atan(vTexCoord.y, vTexCoord.x);

        mat2 rotMatrix = mat2(cos(angle), sin(angle), -sin(angle), cos(angle));



        gl_Position = screenPos = height * pos_cameraspace + vec4(rotMatrix * vec2(size[0], -size[0]), 0.0, 0.0) * aR;
        vTexCoord = vec2(1.0, 0.0);
        EmitVertex();

        gl_Position = screenPos = height * pos_cameraspace + vec4(rotMatrix * vec2(size[0], size[0]), 0.0, 0.0) * aR;
        vTexCoord = vec2(1.0, 1.0);
        EmitVertex();

        gl_Position = screenPos = height * pos_cameraspace + vec4(rotMatrix * vec2(-size[0], -size[0]), 0.0, 0.0) * aR;
        vTexCoord = vec2(0.0, 0.0);
        EmitVertex();

        gl_Position = screenPos = height * pos_cameraspace + vec4(rotMatrix * vec2(-size[0], size[0]), 0.0, 0.0) * aR;
        vTexCoord = vec2(0.0, 1.0);
        EmitVertex();


    EndPrimitive();
}
 
