////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330

/*
layout(std140) uniform bAffine3D
{
    mat4 uProjectionMatrix;
    mat4 uInverseProjectionMatrix;
    mat4 uViewMatrix;
};
*/

uniform mat4 uProjectionMatrix;
uniform mat4 uInverseProjectionMatrix;
uniform mat4 uViewMatrix;

in vec4 aPosition;
in vec4 aVelocity;
in float aLifetime;

out float size;


flat out int vID;

out vec4 vPosition;
out vec4 vVelocity;
out float vLifetime;

void main()
{
    //float viewportHeight = uViewport.y;
    vec4 position = vec4(aPosition.xyz, 1.0);
    size = aPosition.w;

    //vTexCoord = 0.5 * aPosition.xy + 0.5;


    // pass world space position
    vPosition = position;

    // transform position
    gl_Position = uProjectionMatrix * uViewMatrix * position;

    // calculate pointsize
    //gl_PointSize = (viewportHeight * size) / distance(position.xyz, uEye);

    // rendering particles with size 0.0 may result in undefined behaivor
    //gl_PointSize = clamp(gl_PointSize, 0.01, 64.0);

    // derive an alpha value from particle size
    //alphaScale = clamp(0.05 / size, 0.001, 0.2);

    vID = gl_VertexID;

    vVelocity = aVelocity;
    vLifetime = aLifetime;
}
