////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330


uniform mat4 uProjectionMatrix;
uniform mat4 uInverseProjectionMatrix;
uniform mat4 uViewMatrix;

uniform sampler2D uTexture;
uniform sampler2D uNormalMap;

uniform vec4 uLightDirection;

in vec2 vTexCoord;

in float lifetime;
in vec4 screenPos;

out vec4 oColor;

vec3 directionalLight(
    vec3 diffuse,
    float glow,
    vec3 specColor,
    vec3 ambient,
    vec3 eyeLightDir,
    vec3 lightColor,
    vec3 eyeVPos,
    vec3 eyeNormal
    );

void main()
{

    vec4 color = texture(uTexture, vTexCoord);

    if(color.r < 0.02)
    {
        discard;
    }

    vec3 normal = normalize(texture(uNormalMap, vTexCoord).xyz * 2.0 - 1.0);

    vec4 eyePos = uInverseProjectionMatrix * screenPos;
    eyePos /= eyePos.w;

    oColor.rgb = directionalLight(
                color.rgb,
                0.0f,
                vec3(1.0),
                vec3(0.15),
                (uViewMatrix * uLightDirection).xyz,
                vec3(1.0),
                eyePos.xyz,
                normal
                );
    oColor.a = 1.0;



}
