////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

layout(points) in;
layout(points, max_vertices = 1) out;

uniform float uElapsedTime;

in vec4 vVelocity[1];
in float vLifetime[1];
flat in int vRandomSeed[1];

out vec4 velocity_out;
out float lifetime_out;
flat out int seed;

int extraSeed;


vec3 dampField(vec3 velocity, float strength)
{
        return -velocity * strength * uElapsedTime;
}

vec3 noiseField(float strength)
{
        vec3 result;
        extraSeed = (extraSeed + 1) % 2147483647;
        seed = (seed * extraSeed) % 2147483647;
        seed = (seed * 1103515245 + 12345) % 2147483647; result.x = float(seed);
        seed = (seed * 1103515245 + 12345) % 2147483647; result.y = float(seed);
        seed = (seed * 1103515245 + 12345) % 2147483647; result.z = float(seed);
        return uElapsedTime * strength * ((result / 2147483647.0) - vec3(0.5,0.5,0.5));
}

void main()
{
    extraSeed = vRandomSeed[0];

    velocity_out = vec4(0.0);
    seed = 0;

    // get all particle data
    vec3 position = gl_in[0].gl_Position.xyz;
    float size = gl_in[0].gl_Position.w;

    vec3 velocity = vVelocity[0].xyz;
    float lifetime = vVelocity[0].w;

    // update lifetime and discard dead particles
    lifetime -= uElapsedTime;

    if (lifetime <= 0.0)
        return;

    // update position and size
    position += velocity * uElapsedTime;
    size -= 1.0 * size * uElapsedTime / vLifetime[0];
    //size = 20.0 * pow(1 - lifetime / vLifetime[0], 7.0);

    // read current random seed
    seed = vRandomSeed[0];

    // write vertex
    gl_Position = vec4(position, size);
    velocity_out = vec4(velocity, lifetime);
    lifetime_out = vLifetime[0];

    EmitVertex();
    EndPrimitive();
}
