#version 150

uniform sampler2DRect uSamplerColor;
uniform float uWidth;
uniform vec2 uBlurVector;
uniform float uScale;
uniform vec2 uOffset;

out vec4 fFragData0;

void main(void)
{
    vec4 color   = texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy)*0.16;
    vec2 mBlurVector = uWidth*uBlurVector/8.0;

    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy+mBlurVector)*0.15;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy+2.0*mBlurVector)*0.12;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy+3.0*mBlurVector)*0.09;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy+4.0*mBlurVector)*0.06;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy-mBlurVector)*0.15;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy-2.0*mBlurVector)*0.12;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy-3.0*mBlurVector)*0.09;
    color     += texture(uSamplerColor, uOffset + uScale*gl_FragCoord.xy-4.0*mBlurVector)*0.06;

    fFragData0 = color;
}
