#version 150

uniform sampler2DRect uSamplerColor;
uniform float uThreshold;

out vec4 fFragData0;

void main(void)
{
    vec4 color = texture(uSamplerColor,gl_FragCoord.xy);//-vec4(uThreshold);
    vec4 result;
//    if(color.r>=uThreshold)
//        result.r = color.r;
//    else
//        result.r = 0.0;
//    if(color.g>=uThreshold)
//        result.g = color.g;
//    else
//        result.g = 0.0;
//    if(color.b>=uThreshold)
//        result.b = color.b;
//    else
//        result.b = 0.0;

    float smoothWidth = 0.3f;

    float pi_2 = 3.141592653589*0.5;

    vec3 x = ((color.rgb - uThreshold) / smoothWidth ) * pi_2;

    result.r = sin(clamp(x.r, -pi_2, pi_2)) * 0.5 + 0.5;
    result.g = sin(clamp(x.g, -pi_2, pi_2)) * 0.5 + 0.5;
    result.b = sin(clamp(x.b, -pi_2, pi_2)) * 0.5 + 0.5;
    result.a = 1.0;
    fFragData0 = result;//max(texture(uSamplerColor,gl_FragCoord.xy)-vec4(uBias),vec4(0.0));
}
