////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150


uniform sampler2DRect uSamplerHalf;
uniform sampler2DRect uSamplerColor;
uniform sampler2D     uSamplerDepth;

uniform vec2          uBlurVector;
uniform vec2          uCameraRange;
uniform float         uScaleFactorDepth;
uniform float uCameraHeight;
uniform float uCameraWidth;

out vec4 fFragData0;

vec2 fragCoordToTexCoord( in vec2 _coord)
{
    return vec2(_coord.x*uScaleFactorDepth/uCameraWidth,_coord.y*uScaleFactorDepth/uCameraHeight);
}

float readDepth( in vec2 _coord ) {


    float value = texture( uSamplerDepth, fragCoordToTexCoord(_coord)).x;

    return -uCameraRange.y * uCameraRange.x  /( value * (uCameraRange.y - uCameraRange.x) - uCameraRange.y);
}
void main(void)
{
    float CoC = 2*max(abs(texture(uSamplerColor, gl_FragCoord.xy*2.0).a),abs(texture(uSamplerHalf, gl_FragCoord.xy).a)) - abs(texture(uSamplerColor, gl_FragCoord.xy*2.0).a);
    //Limit the CoC to a Maximum Value so we wont get interferences
    if(CoC>8.0)
        CoC = 8.0;
    //normalize the Vector we use to Blur, to avoid artifacts.
    vec2 mBlurVec = uBlurVector*CoC/8.0;
    vec4 color   = vec4(texture(uSamplerHalf, gl_FragCoord.xy).rgb,1.0)*0.16;
    float myDepth = readDepth(gl_FragCoord.xy);

    if(readDepth(gl_FragCoord.xy+mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy+mBlurVec).rgb,1.0)*0.15;
    if(readDepth(gl_FragCoord.xy+2*mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy+2*mBlurVec).rgb,1.0)*0.12;
    if(readDepth(gl_FragCoord.xy+3*mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy+3*mBlurVec).rgb,1.0)*0.09;
    if(readDepth(gl_FragCoord.xy+4*mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy+4*mBlurVec).rgb,1.0)*0.06;
    if(readDepth(gl_FragCoord.xy-mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy-mBlurVec).rgb,1.0)*0.15;
    if(readDepth(gl_FragCoord.xy-2*mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy-2*mBlurVec).rgb,1.0)*0.12;
    if(readDepth(gl_FragCoord.xy-3*mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy-3*mBlurVec).rgb,1.0)*0.09;
    if(readDepth(gl_FragCoord.xy-4*mBlurVec)<= myDepth)
        color     += vec4(texture(uSamplerHalf, gl_FragCoord.xy-4*mBlurVec).rgb,1.0)*0.06;
    color     = color/color.a;
    color.a = abs(texture(uSamplerHalf, gl_FragCoord.xy).a);

    fFragData0   = color;
}
