////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerColor;

uniform vec2          uBlurVector;

out vec4 fFragData0;

void main(void)
{
    vec4 color   = abs(texture(uSamplerColor, gl_FragCoord.xy));
    color.a = color.a*0.16;

    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy+uBlurVector).a*0.15);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy+2*uBlurVector).a*0.12);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy+3*uBlurVector).a*0.09);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy+4*uBlurVector).a*0.06);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy-uBlurVector).a*0.15);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy-2*uBlurVector).a*0.12);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy-3*uBlurVector).a*0.09);
    color.a     += abs(texture(uSamplerColor, gl_FragCoord.xy-4*uBlurVector).a*0.06);


    color.a = max(color.a,texture(uSamplerColor, gl_FragCoord.xy).a);
    fFragData0   = color;
}
