////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerColor;
uniform sampler2DRect     uSamplerCircleOfConfusion;

uniform float uScaleFactor;

out vec4 fFragData0;

void main(void)
{
    vec4 color   = texture(uSamplerColor, gl_FragCoord.xy*uScaleFactor);
    //apply smallBlur
    vec4 colorBlur       = texture(uSamplerColor, gl_FragCoord.xy*uScaleFactor+vec2(1.5,0.5));
    colorBlur       += texture(uSamplerColor, gl_FragCoord.xy*uScaleFactor+vec2(0.5,-1.5));
    colorBlur       += texture(uSamplerColor, gl_FragCoord.xy*uScaleFactor+vec2(-1.5,-0.5));
    colorBlur       += texture(uSamplerColor, gl_FragCoord.xy*uScaleFactor+vec2(-0.5,1.5));
    colorBlur       = colorBlur/4.0;

    //centersample is aggregated seperatly to avoid muddy artifacts.
    color           += colorBlur;
    color           = color / 2.0;
    color.a         = abs(texture(uSamplerCircleOfConfusion, gl_FragCoord.xy*uScaleFactor).a);

    fFragData0   = color;
}
