////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerColor;
uniform float uCtr;

out vec4 fFragData0;

void main(void)
{
    // Get the value of the current screen pixel
    vec4 pixel = texture(uSamplerColor, gl_FragCoord.xy);
    vec4 rgba = vec4(1.0);

    // max and min color channgel value
    float max = max(max(pixel.r,pixel.g),pixel.b);
    float min = min(min(pixel.r,pixel.g),pixel.b);

    vec3 hsv = vec3(0.0);

    if (max == min)
    {
           hsv.r = 0.0;
    }
    else if (max == pixel.r)
    {
           hsv.r = 60.0 * (pixel.g - pixel.b)/(max - min);
    }
    else if (max == pixel.g)
    {
           hsv.r = 60.0 * (2.0 + (pixel.b - pixel.r)/(max - min));
    }
    else
    {
           hsv.r = 60.0 * (4.0 + (pixel.r - pixel.g)/(max - min));
    }
    if (hsv.r < 0.0 )
    {
           hsv.r = hsv.r + 360.0;
    }
    if (max == 0.0)
    {
           hsv.g = 0;
    } else
    {
           hsv.g = (max-min)/max;
    }

    hsv.b = max;
    hsv.r = hsv.r + uCtr;

    if (hsv.r > 360 )
    {
           hsv.r = hsv.r - 360;
    }

    int hi = int(floor(hsv.r/60.0));
    float f = hsv.r/60 - hi;
    vec3 pqt = vec3(0.0);
    pqt.r = hsv.b*(1.0 - hsv.g);
    pqt.g = hsv.b*(1.0 - hsv.g*f);
    pqt.b = hsv.b*(1.0 - hsv.g*(1.0-f));

    switch (hi)
    {
    case 0:
           rgba.rgb = vec3(hsv.b,pqt.b,pqt.r);
           break;
    case 1:
           rgba.rgb = vec3(pqt.g,hsv.b,pqt.r);
           break;
    case 2:
           rgba.rgb = vec3(pqt.r,hsv.b,pqt.b);
           break;
    case 3:
           rgba.rgb = vec3(pqt.r,pqt.g,hsv.b);
           break;
    case 4:
           rgba.rgb = vec3(pqt.b,pqt.r,hsv.b);
           break;
    case 5:
           rgba.rgb = vec3(hsv.b,pqt.r,pqt.g);
           break;
    case 6:
           rgba.rgb = vec3(hsv.b,pqt.b,pqt.r);
           break;
    }

    fFragData0 = rgba;
}
