////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2D uSamplerOcclusion;
uniform vec2 uFlarePosition;
uniform vec2 uProportions;
uniform float uScaleFactor;
uniform float uExtraFlarePass;
uniform float uExtraFlareIntensity;
in vec4 aPosition;

out vec2 TexCoord;
out float occlusion;

void main()
{
    gl_Position = vec4((uProportions*aPosition.xy)*abs(uScaleFactor)+uFlarePosition,aPosition.zw);
    TexCoord = aPosition.xy*0.5+0.5;
    if(uExtraFlarePass > 0.5)
        occlusion = uExtraFlareIntensity;
    else
        occlusion = texture(uSamplerOcclusion,vec2(0.5)).x;
}
