////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

in vec2 vTexCoordScreen;
out vec4 fFragData0;

uniform sampler2DRect uSamplerColor;
uniform sampler2DRect uSamplerVelocity;

uniform float uMultiplier;
uniform float uCameraHeight;
uniform float uCameraWidth;


void main(void)
{
    vec4 velocity = texture(uSamplerVelocity,gl_FragCoord.xy);

    // finished computing velocity

    vec4 color = texture(uSamplerColor, gl_FragCoord.xy);
    vec2 position = gl_FragCoord.xy;

    for(int i = 0; i < 9; ++i, position += (uMultiplier*velocity.xy/9.0))
    {
        //do not take samples from the masked off area
        if(texture(uSamplerVelocity,position).a >= 0.0)
        {
            //clamping to the borders will result in notable flickering
            //to avoid that samples out side of the image are being ignored.
            //a possible artifakt will be less blurring near borders

            if(position.x<=uCameraWidth-1.0 && position.x>=1.0 && position.y<=uCameraHeight-1.0 && position.y>=1.0)
                color += vec4(texture(uSamplerColor, position).rgb,1.0);
        }
    }
    color = color /color.a;
    fFragData0 = color;
    fFragData0.a = 1.0;

}
