////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerColor;

out vec4 fFragData0;

void main(void)
{
    vec4 col   = texture(uSamplerColor, gl_FragCoord.xy);
    col.a = (col.r + col.g + col.b)/3.0;

    fFragData0 = vec4(min(max(0.0, col.a + 0.16), 1.0),
                      min(max(0.0, col.a + 0.08), 1.0),
                      min(max(0.0, col.a - 0.12), 1.0),
                      0.0);
}
