#version 150

uniform sampler2D uSamplerDepth;
uniform vec2 uSunPosition;
uniform vec2 uSunSize;
in vec2 TexCoord;
out vec4 fFragData0;


void main(void)
{
    fFragData0 = vec4(0.0);
    float counter = 0.0;
    vec2 position = TexCoord + uSunPosition*0.5 + 0.5;
    for(int i = -2; i<=2;i++)
    {
        for(int j = -2; j<=2;j++)
        {
            vec2 newpos = position+vec2(i*uSunSize.x,j*uSunSize.y);
            if(texture(uSamplerDepth,newpos).z == 1.0 )
                counter++;
        }
    }
    fFragData0 = vec4(counter/25.0);
}
