
////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerColor;
uniform float uExposure;
uniform float uLumCap;

out vec4 fFragData0;

void main(void)
{
    vec4 color = texture(uSamplerColor, gl_FragCoord.xy);

    float YD = uExposure * (uExposure/uLumCap + 1.0) / (uExposure + 1.0);
    color = color*(0.5*YD + 0.5);

    fFragData0 =  color;
}
