////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerEyeNormal;
uniform sampler2D uSamplerCurrentFrameDepth;
uniform sampler2DRect uSamplerCurrentFrameColor;

uniform samplerCube uSamplerSky;

uniform mat4 uProjectionMatrix;
uniform mat4 uProjectionMatrixInverse;
uniform mat3 uInvNormalMat;

uniform float uMarchingStepLimit;
uniform float uMarchingStepSizeJittered[20];
uniform vec2  uScreenSize;

in vec2 vTexCoordScreen;

out vec4 fFragData0;

/*float linearize(float depth)
{
    float f =1000.0;
    float n = 0.1;
    return((2 * n) / (f + n - depth * (f - n)));
}

const float f =1000.0;
const float n = 0.1;*/

void main (void)
{
    ivec2 screenSize = textureSize(uSamplerCurrentFrameColor);

    vec4 color      = texture(uSamplerCurrentFrameColor, vTexCoordScreen * screenSize);
    vec4 eyeNormal  = texture(uSamplerEyeNormal, vTexCoordScreen * screenSize);
    eyeNormal.rgb   = eyeNormal.rgb * 2.0 - 1.0;


    if(eyeNormal.a < 0.01)
    {
        fFragData0 = vec4(0,0,0,1);
        return;
    }


    // Compute eye space position
    vec4 ndc = vec4(vTexCoordScreen.x, vTexCoordScreen.y,
                    texture(uSamplerCurrentFrameDepth, vTexCoordScreen.xy).x, 1.0) * 2.0 - 1.0;
    vec4 eyeSurfacePosition = uProjectionMatrixInverse * ndc;
    eyeSurfacePosition /= eyeSurfacePosition.w;

    vec3 eyeViewingRay          = -normalize(-eyeSurfacePosition.xyz);
    vec3 eyeReflectedViewingRay = reflect(eyeViewingRay, normalize(eyeNormal.xyz));
    eyeReflectedViewingRay      =  normalize(eyeReflectedViewingRay);
    
    // Project the surface and reflected surface position to screen space
    vec3 eyeReflectedSurfacePosition    = eyeSurfacePosition.xyz + eyeReflectedViewingRay;
    vec4 screenReflectedSurfacePosition = (uProjectionMatrix * vec4(eyeReflectedSurfacePosition, 1.0));
    screenReflectedSurfacePosition.xyz /= screenReflectedSurfacePosition.w;
    vec4 screenSurfacePosition          = (uProjectionMatrix * eyeSurfacePosition);
    screenSurfacePosition.xyz          /= screenSurfacePosition.w;

    // Map to [0, 1]
    screenReflectedSurfacePosition.xyz   = 0.5 * screenReflectedSurfacePosition.xyz + vec3(0.5);
    screenSurfacePosition.xyz            = 0.5 * screenSurfacePosition.xyz + vec3(0.5);

    // Compute screen space reflection vector
    vec3 screenReflectedViewingRay = screenReflectedSurfacePosition.xyz - screenSurfacePosition.xyz;

    // compute the scale factor, so that the screenReflectedViewingRay covers x pixels 
    float scale = (2.0 / uScreenSize.x) / length(screenReflectedViewingRay.xy);

    vec3 screenReflectedViewingRayRef = screenReflectedViewingRay * scale;
    int startIndex = int(mod(gl_FragCoord.x * gl_FragCoord.y, 20));
    screenReflectedViewingRay *= scale * uMarchingStepSizeJittered[startIndex];

    // now start the ray marching
    vec3 screenLastMarchingPosition     = screenSurfacePosition.xyz + screenReflectedViewingRay;
    vec3 screenCurrentMarchingPosition  = screenLastMarchingPosition.xyz + screenReflectedViewingRay;

    vec4 reflectionColor = vec4(0,0,0,0);
    
    float currentSampledDepth = 1.0;
    float lastSampledDepth    = texture(uSamplerCurrentFrameDepth, screenLastMarchingPosition.xy).x;

    int i = 0;
    while(screenCurrentMarchingPosition.x >= 0.0 && screenCurrentMarchingPosition.x <= 1.0 && 
        screenCurrentMarchingPosition.y >= 0.0 && screenCurrentMarchingPosition.y <= 1.0 && 
        i < uMarchingStepLimit && lastSampledDepth < 1.0)
    {
        currentSampledDepth = texture(uSamplerCurrentFrameDepth, screenCurrentMarchingPosition.xy).x;
        if( lastSampledDepth > screenLastMarchingPosition.z &&
            screenCurrentMarchingPosition.z > currentSampledDepth &&
            abs(lastSampledDepth - currentSampledDepth) < abs(screenReflectedViewingRay.z * 1.55))
        {
            float denominator = ((currentSampledDepth - lastSampledDepth) * 1.0 - 1.0 * (screenCurrentMarchingPosition.z - screenLastMarchingPosition.z));
            float numA = (screenLastMarchingPosition.z - lastSampledDepth);
            float paramA = numA / denominator;

            if(denominator != 0.0 && 0 <= paramA && paramA <= 1)
            {
                screenCurrentMarchingPosition.xy = screenLastMarchingPosition.xy + paramA * screenReflectedViewingRay.xy;
            }
            else
            {
                break;
            }

            float fadeOut = 1.0;
            fadeOut *= 1.0 - max(abs(0.5 - screenCurrentMarchingPosition.x) - (0.5 - 0.2), 0.0) / 0.2;
            fadeOut *= 1.0 - max(abs(0.5 - screenCurrentMarchingPosition.y) - (0.5 - 0.2), 0.0) / 0.2;

            reflectionColor.rgb =  texture(uSamplerCurrentFrameColor, screenSize.xy * screenCurrentMarchingPosition.xy).rgb;
            reflectionColor.a = 1.0;
            reflectionColor *= fadeOut;
            break; 
        }
        else
        {  
            screenLastMarchingPosition = screenCurrentMarchingPosition;
            lastSampledDepth = currentSampledDepth;
            screenCurrentMarchingPosition += screenReflectedViewingRay;
            screenReflectedViewingRayRef *= 1.05;
            float stepSize = uMarchingStepSizeJittered[int(mod(startIndex + i, 20))];
            screenReflectedViewingRay = screenReflectedViewingRayRef * stepSize;
            ++i;
        }
    }

    vec3 skyDir = normalize(uInvNormalMat * eyeReflectedViewingRay);
    vec4 skyReflection = texture(uSamplerSky, skyDir);

    fFragData0.rgb = mix(skyReflection.rgb, reflectionColor.rgb, reflectionColor.a)*0.5*eyeNormal.a;
    fFragData0.a   = 1.0;
}
