////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform sampler2DRect uSamplerEyeNormal;
uniform sampler2D uSamplerDepth;
uniform vec2 uCameraRange;
uniform vec2 uScreenSize;
uniform float uAOMultiplier;
uniform float uDepthTolerance;

in vec2 vTexCoordScreen;

out vec4 fFragDataSSAO;

float readDepth( in vec2 coord ) {
    return (2.0 * uCameraRange.x) / (uCameraRange.y + uCameraRange.x - texture( uSamplerDepth, coord ).x * (uCameraRange.y - uCameraRange.x));
}

void main(void)
{
    float useNormal = texture(uSamplerEyeNormal, gl_FragCoord.xy).a;
    float depth = readDepth( vTexCoordScreen );
    float d;

    float pw = 1.0 / uScreenSize.x;
    float ph = 1.0 / uScreenSize.y;

    float aoCap = 1.0;
    float ao = 0.0;
    float currentAOMultiplier = uAOMultiplier;

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    pw*=2.0;
    ph*=2.0;
    currentAOMultiplier/=2.0;

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    pw*=2.0;
    ph*=2.0;
    currentAOMultiplier/=2.0;

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    pw*=2.0;
    ph*=2.0;
    currentAOMultiplier/=2.0;

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y+ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x+pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    d=readDepth( vec2(vTexCoordScreen.x-pw,vTexCoordScreen.y-ph));
    ao+=min(aoCap,max(0.0,depth-d-uDepthTolerance) * currentAOMultiplier);

    ao/=16.0;

    fFragDataSSAO = vec4(max((1.0 - ao),(1.0 - useNormal)));
}
