////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2DRect uSamplerSourceTexture;
uniform sampler2DRect uSamplerCurrentFrameColor;
uniform float  uScale;

in vec2 vTexCoordScreen;

out vec4 fFragData0;

void main (void)
{   
    vec4 color = texture(uSamplerCurrentFrameColor, gl_FragCoord.xy);
    vec4 reflections1 = texture(uSamplerSourceTexture, gl_FragCoord.xy * vec2(uScale));
    vec4 reflections2 = texture(uSamplerSourceTexture, (gl_FragCoord.xy+vec2(0, 1)) * vec2(uScale));
    /*vec4 reflections2 = texture(uSamplerSourceTexture, (gl_FragCoord.xy + vec2(-1, 0)) * vec2(scale));
    vec4 reflections3 = texture(uSamplerSourceTexture, (gl_FragCoord.xy + vec2(1, 0)) * vec2(scale));
    vec4 reflections4 = texture(uSamplerSourceTexture, (gl_FragCoord.xy + vec2(0, -1)) * vec2(scale));
    vec4 reflections5 = texture(uSamplerSourceTexture, (gl_FragCoord.xy + vec2(0, 1)) * vec2(scale));*/

    vec3 reflections = vec3(0);
    reflections += reflections1.rgb;
    reflections += reflections2.rgb;
    /*reflections += reflections3.rgb;
    reflections += reflections4.rgb;
    reflections += reflections5.rgb;
    */reflections /= 2.0;

    fFragData0 = vec4(color.rgb + reflections.rgb, 1);
}
