////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330

#pragma ACGLimport "Camera.glsl"

in vec4  aPosition;
in vec3  aInstanceColor;
in vec3  aInstancePosition;
in float aInstanceSize;

out vec3 vColor;
out vec3 vNormal;

void main()
{
    gl_Position = uProjectionMatrix * uViewMatrix * vec4(aPosition.xyz * aInstanceSize + aInstancePosition, 1.0);
    vColor = aInstanceColor;
    vNormal = normalize(aPosition.xyz);
}
