#version 330

// Returns (fogColor.rgb, fogIntensity) for a given distance d
vec4 getFogColor(float d)
{
    // This is a scientifically accurate and well-founded fog model!
    float blend = clamp(1.0 - exp(-0.001 * d), 0.0, 1.0);
    vec3 color = mix(vec3(47.0/255.0, 59/255.0, 157/255.0), vec3(1.0, 1.0, 1.0), blend);
    return vec4(color, blend);
}
