////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"
#pragma ACGLimport "Fog.glsl"
#pragma ACGLimport "Lighting.glsl"

uniform sampler2D uSamplerGrass;
uniform sampler2D uSamplerGravel;
uniform sampler2D uSamplerSnow;
uniform sampler2D uSamplerNoise;

out vec4 fColor;

in vec3 vEyePosition;
in vec3 vWorldPosition;
in vec3 vNormal;
in vec3 vRandColor;

void main()
{
    vec2 texCoord = vec2(0.125) * vWorldPosition.xz;

    vec3 noise  = texture(uSamplerNoise,  texCoord * 0.1).rgb - 0.5;

    vec3 grass  = texture(uSamplerGrass,  texCoord).rgb;
    vec3 gravel = texture(uSamplerGravel, texCoord).rgb + 0.1 * noise;
    vec3 snow   = texture(uSamplerSnow,   texCoord).rgb;

    float heightModulation = (length(vRandColor) * 2.0 - 1.0) * 30.0;
    float height           = vWorldPosition.y + heightModulation;
    float snowLine         = 180.0;
    float gravelLine       = 60.0;
    float lineWidth        = 10.0;

    float snowIntensity   = smoothstep(snowLine - lineWidth, snowLine + lineWidth, height);
    float grassIntensity  = 1.0 - smoothstep(gravelLine - lineWidth, gravelLine + lineWidth, height);
    float gravelIntensity = 1.0 - snowIntensity - grassIntensity;

    vec3 diffuseColor = snowIntensity * snow + gravelIntensity * gravel + grassIntensity * grass + 0.015 * (vRandColor * 2.0 - 1.0);

    vec3 normal = normalize(vNormal);

    vec4 fogColor = getFogColor(-vEyePosition.z);
    vec3 phongColor = sunLighting(vWorldPosition, normal, uWorldCameraPosition, diffuseColor, 0.0);
    fColor.rgb = mix(phongColor, fogColor.rgb, fogColor.a);
    fColor.a = 1.0;
}
