////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"
#pragma ACGLimport "Fog.glsl"
#pragma ACGLimport "Lighting.glsl"

uniform vec3 uVelocity;

in vec3 vEyePosition;
in vec3 vWorldPosition;
in vec3 vWorldNormal;
in vec3 vColor;

out vec4 fColor;
out vec3 fVelocity;

void main()
{
    vec3 normal = normalize(vWorldNormal);

    vec3 diffuseColor = vColor;

    vec3 phongColor = sunLighting(vWorldPosition, normal, uWorldCameraPosition, diffuseColor, 1.0);
    vec4 fogColor = getFogColor(-vEyePosition.z);
    fColor.rgb = mix(phongColor, fogColor.rgb, fogColor.a);
    fColor.a = 1.0;

    fVelocity = uVelocity;
}
