////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"
#pragma ACGLimport "Lighting.glsl"

uniform samplerCube uSamplerSkybox;
uniform sampler2D   uSamplerNoise;

in vec4 vRayOrigin;
in vec2 vScreenPosition;

out vec4 fColor;
out vec3 fSun;

void main()
{
    vec4 frustumRay = uProjectionMatrixInverse * vec4(vScreenPosition, 1.0, 1.0);
    frustumRay = vec4(frustumRay.xyz / frustumRay.w, 0.0);
    vec4 rayDirection = normalize(uViewMatrixInverse * frustumRay);

    fColor = texture(uSamplerSkybox, rayDirection.xyz);

    float sunIntensity = pow(max(dot(rayDirection.xyz, uSunDirection), 0.0), 128.0);
    fColor.xyz += vec3(sunIntensity);

    float noise = 0.75 + 0.5 * texture(uSamplerNoise, gl_FragCoord.xy / vec2(256.0)).r;

    sunIntensity *= noise;

    fSun = vec3(sunIntensity);
}
