////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330

#pragma ACGLimport "Camera.glsl"

in vec4 aPosition;
in vec3 aInstancePosition;
in uint aInstanceID;

flat out uint vInstanceID;

void main()
{
    vInstanceID = aInstanceID;
    gl_Position = uProjectionMatrix * uViewMatrix * vec4(aPosition.xyz * 0.5 + aInstancePosition, 1.0);
}
