////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330

#pragma ACGLimport "Camera.glsl"

in vec3 aPosition;
in vec3 aColor;

out vec3 vColor;

void main()
{
    vec4 worldPosition = vec4(aPosition,1.0);
    vec4 eyePosition   = uViewMatrix * worldPosition;
    gl_Position        = uProjectionMatrix * eyePosition;

    vColor = aColor;

}
