////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"
#pragma ACGLimport "Lighting.glsl"


in vec4 aPosition;

out vec2  vScreenTexCoord;
out vec2  vScreenSunCoord; // Sun position in [0,1]x[0,1] screen coords
out float vSunIntensity;   // Sun intensity falls off if sun is outside of screen

void main()
{
    gl_Position = aPosition;

    vec4 eyeSunVanishingDirection = uViewMatrix * vec4(-uSunDirection, 0.0);
    vScreenSunCoord = vec2(
        uProjectionMatrix[0][0] * eyeSunVanishingDirection.x + uProjectionMatrix[2][0] * eyeSunVanishingDirection.z,
        uProjectionMatrix[1][1] * eyeSunVanishingDirection.y + uProjectionMatrix[2][1] * eyeSunVanishingDirection.z
    ) / (-eyeSunVanishingDirection.z);

    vScreenTexCoord = aPosition.xy * 0.5 + 0.5;
    vScreenSunCoord = vScreenSunCoord * 0.5 + 0.5;

    vSunIntensity = 1.0;
}
