////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"

uniform mat4 uModelMatrix;

in vec4 aPosition;
in vec3 aNormal;
in vec3 aColor;

out vec3 vNormal;
out vec3 vEyePosition;
out vec3 vWorldPosition;
out vec3 vRandColor;

void main()
{
    vec4 eyePosition     = uViewMatrix * aPosition;
    gl_Position          = uProjectionMatrix * eyePosition;

    vWorldPosition       = aPosition.xyz;
    vEyePosition         = eyePosition.xyz;
    vNormal              = aNormal;
    vRandColor           = aColor;
}
