////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"

uniform mat4 uModelMatrix;

in vec4 aPosition;
in vec3 aNormal;

out vec3 vNormal;
out vec3 vWorldPosition;
out vec3 vWorldCameraPosition;
out vec3 vRandColor;

void main()
{
    gl_Position          = uProjectionMatrix * uViewMatrix * aPosition;
    vWorldPosition       = aPosition.xyz;
    vNormal              = aNormal;
    vWorldCameraPosition = (inverse(uViewMatrix) * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
    vRandColor           = vec3(mod(aPosition.x*13 + aPosition.y*17 + aPosition.z*23,1.0), mod((aPosition.x*7 + aPosition.y*31 + aPosition.z*43),1.0), mod((aPosition.x*37 + aPosition.y*5 + aPosition.z*2),1.0));
}
