////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330

uniform mat4 uLastViewMatrix;

#pragma ACGLimport "Camera.glsl"
#pragma optionNV unroll all

uniform sampler2D uSamplerInput;
uniform sampler2D uSamplerDepth;
uniform sampler2D uSamplerVelocity;

uniform float uElapsedTime;

in vec2 vTexCoordScreen;
in vec2 vPosition;

out vec4 fColor;

void main()
{
    float depth = texture(uSamplerDepth, vTexCoordScreen).x * 2.0 - 1.0;
    vec4 velocity = vec4(texture(uSamplerVelocity, vTexCoordScreen).xyz, 0.0);

    vec4 ndcPosition = vec4(vPosition.x, vPosition.y, depth, 1.0);
    vec4 worldPosition = uViewMatrixInverse * uProjectionMatrixInverse * ndcPosition;
    worldPosition /= worldPosition.w;
    vec4 oldWorldPosition = worldPosition - uElapsedTime * velocity;
    vec4 lastNdcPosition = uProjectionMatrix * uLastViewMatrix * oldWorldPosition;
    lastNdcPosition /= lastNdcPosition.w;

    vec2 sampleDirection = (lastNdcPosition.xy - ndcPosition.xy) * 1.0;
    const int maxNumSamples = 10;

    vec2 samplePosStart = ndcPosition.xy + ((maxNumSamples+1)%2)*sampleDirection/maxNumSamples/2.0;

    float sgn = 1.0;

    vec4 accumulatedColor = vec4(0.0);
    for(int i = 1; i < maxNumSamples+1; i++)
    {
        vec2 samplePos = (samplePosStart + sgn*sampleDirection * (float(i/2) / maxNumSamples)) * 0.5 + 0.5;
        sgn *= -1.0;
        accumulatedColor += texture(uSamplerInput, samplePos);
    }
    fColor = accumulatedColor / maxNumSamples;
}
