////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 330

#pragma ACGLimport "Camera.glsl"

uniform mat4 uModelMatrix;
uniform mat3 uModelNormalMatrix;

in vec4 aPosition;
in vec3 aNormal;
in vec4 aColor;

out vec3 vEyePosition;
out vec3 vWorldPosition;
out vec3 vWorldNormal;
out vec3 vColor;

void main()
{
    vec4 worldPosition = uModelMatrix * aPosition;
    vec4 eyePosition   = uViewMatrix * worldPosition;
    gl_Position        = uProjectionMatrix * eyePosition;

    vEyePosition   = eyePosition.xyz;
    vWorldPosition = worldPosition.xyz;
    vWorldNormal   = uModelNormalMatrix * aNormal;
    vColor         = aColor.rgb;
}
