////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform mat4 uProjectionMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uModelMatrix;

in vec4 aPosition;

out float vZ;

void main()
{
    // eye pos
    vec4 pos = uProjectionMatrix * uViewMatrix * uModelMatrix * aPosition;

    vZ = pos.z;

    // projected vertex position used for the interpolation
    gl_Position  = pos;
}
