////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

#pragma ACGLimport "Camera.glsl"

in vec4 aPosition;

out vec4 vRayOrigin;
out vec2 vScreenPosition;

void main()
{
    // Render the sky at maximum z value, so it is rendered behind everything
    gl_Position     = vec4(aPosition.xy, 1.0, aPosition.w);

    vRayOrigin = uViewMatrixInverse * vec4(0.0, 0.0, 0.0, 1.0);
    vScreenPosition = aPosition.xy;
}
