/**
 * Write your names and matriculation numbers here!
 */
import java.util.Arrays;

public class Heap {

    public class QueueEmptyException extends Exception {}
    public class QueueFullException extends Exception {}

    private int[] S;
    private int back;

    // Constructor
    public Heap() {
        this.S = new int[10];
        this.back = 1;
    }

    // Get element at index i (starting at index 1)
    private int get(int i) {
        return this.S[i-1];
    }

    // Set element i to value x
    private void set(int i, int x) {
        this.S[i-1] = x;
    }

    // Swap elements at index i and j
    private void swap(int i, int j) {
        int x = this.get(i);
        this.set(i, this.get(j));
        this.set(j, x);
    }

    // Get length of queue
    private int length() {
        return this.S.length;
    }

    // Enqueue element x
    public void Enq(int x) throws QueueFullException {
        if (this.Full()) {
            // Throw exception if queue is full
            throw new QueueFullException();
        } else {
            int i = this.back;
            this.back++;
            this.set(i, x);

            // Restore heap condition
            while (i != 1 && this.get(i) > this.get(i/2)) {
                this.swap(i, i/2);
                i /= 2;
            }
        }
    }

    // Dequeue element
    public void Deq() throws QueueEmptyException {
        if (this.Empty()) {
            // Throw exception if queue is empty
            throw new QueueEmptyException();
        } else {
            int i = 1;
            this.back--;
            this.set(1, this.get(this.back));

            // Restore heap condition
            while (i <= (back - 1) / 2) {
                
                // Consider first (left) child
                int j = 2*i;
                
                // If right child exists and
                // is greater than left one
                // consider right child
                if (j < back-1 && this.get(j) < this.get(j+1)) {
                    j++;
                }
                
                // Swap node with its child if the greater
                // of them is still greater than node i
                if (this.get(i) < this.get(j)) {
                    this.swap(i, j);
                    i = j;
                } else {
                    // Both child nodes are smaller or equal
                    i = back;
                }
            }
        }
    }

    // Get first element in queue
    public int Get() throws QueueEmptyException {
        if (this.Empty()) {
            // Throw exeption if queue is empty
            throw new QueueEmptyException();
        } else {
            return this.get(1);
        }
    }

    // Is queue empty?
    public boolean Empty() {
        return this.back == 1;
    }

    // Is queue full?
    public boolean Full() {
        return this.back == this.length() + 1;
    }

    // Print queue
    public String printQueue() {
        String res = "[";
        int i = 1;
        for (; i < this.back; i++) {
            res += this.get(i);
            if(i != this.length()) res += ", ";
        }
        for (i = this.back; i < this.length(); i++) {
            res += "_";
             if(i < this.length() - 1) res += ", ";
        }
        res += "]";
        return res;
    }
}
